# StarXpand SDK for Web Developer's manual V0.1.3  
 
## Overview  
  
StarXpand SDK for Web is a software development kit that includes sample codes and star-io10-web library that can control devices connected to a host device with USB from web application run on web browser  
  
## Environments  

For details, please refer to [README](../README.md).

### Supported OS and Browser

| OS       | Browser |  
| -------- | -------- |  
| Windows  | Chrome   |  
| Windows  | Edge     |  
| macOS    | Chrome   |  
| ChromeOS | Chrome   |  
| Ubuntu   | Chrome   |  
| Android  | Chrome   |  
   
Firefox, Safari are not supported because they do not support WebUSB API as of November, 2025.  
  
### Supported Language  
  
- TypeScript  
  
### Supported interface  
  
- USB  
  
  Android AOA communication is not supported. Please connect with the Printer class.  
  When use TSP100IV series or TSP100IV SK series, please use USB-C port.
  
### Supported printers  
  
- mC-Print3 series  
- mC-Print2 series  
- mC-Label3 series  
- mC-Label2 series  
- mPOP series  
- TSP100IV series  
- TSP100IV-SK series  

## Distribution

Distributed via [npm](https://www.npmjs.com/package/star-io10-web)  
Published on [github](https://github.com/star-micronics/star-io10-web)  

## About replacing USB drivers
In Windows and Ubuntu, it is necessary to replace the USB driver by following the procedure below.

## In Windows
1. Turn on the printer and connect the printer and the host device with a USB cable.  

  The USB port that can communicate with the device varies depending on the printer.
  Please check the online manual or hardware manual of the printer you are using.

2. Replace the printer driver.　　
  Run `example/scripts_for_client/Windows/install.bat` with administrator privileges.
  When you execute the driver replacement, USB printers cannot be used from other software.
  When using the printer with other software, please restore the driver by following the procedure below.

  1. Open Device Manager
  2. Right-click the corresponding printer from "Universal Serial Bus Devices" and select "Update driver"
  3. Select "Browse my computer for drivers"
  4. Select "Let me pick from a list of available drivers on my computer"
  5. Select "USB Printing Support" and click "Next"

## In Ubuntu

1. Turn on the printer and connect the printer and the host device with a USB cable.

  The USB port that can communicate with the device varies depending on the printer.
  Please check the online manual or hardware manual of the printer you are using.

2. Replace the printer driver.　　
  Before using the printer, run the following script with administrator privileges:
  `example/scripts_for_client/linux/onetime.sh`

  When you execute the script, the previously installed printer driver will become unusable.
  The effect of the script will be reverted by performing the following operations. When using the previously installed printer driver, please perform the following operations.
  - Unplug and replug the printer's USB cable
  - Restart the printer
  - Restart ubuntu

## Functions  
  
### StarXpandCommandBuilder  
  
Provides the same functionality as [the react-native version](https://star-m.jp/products/s_print/sdk/react-native-star-io10/manual/en/api-reference/star-xpand-command/index.html).  
However, the following points are different:


#### Way to specify image sources

[the way to specify image sources](https://star-m.jp/products/s_print/sdk/react-native-star-io10/manual/en/api-reference/star-xpand-command/printer/image-parameter/constructor.html) differs:  
  
- Image source specification  
  - Base64-encoded content  
  - Resource file name  

### StarDeviceDiscoveryManager class  
  
Before opening a StarPrinter, obtain access rights to the printer by using `discover()`.  
  
#### Properties  
  
- `onPrinterFound(printer: StarPrinter)`  
Delegate notified when a printer is discovered  
  
#### Methods  
  
- `constructor(interfaceType: InterfaceType)`  
  
- `discover(options: DiscoverOptions): Promise<void>`  
  Executes a discovery.  
  When it runs, a WebUSB API popup will appear. Access rights for the printer selected from the popup are granted by the WebUSB API. 

> Memo
  If the connected printer does not appear in the popup, please change the printer settings by following the methods below.  
  
  Method 1 Change printer settings

  1. Connect to the printer with the Star Quick Setup Utility app  
  2. Open "Device Settings" -> "USB Settings"  
  3. Set "USB-C Function" to "Data only"  
  4. Press "Apply" 

  Method 2 Change connection cable

  1. Change the USB cable connecting the host device and the printer to a A-C cable
  
### StarPrinter class  
  
#### Properties  
  
- `connectionSettings: StarConnectionSettings`  
  
#### Methods  
  
- `constructor(connectionSettings: StarConnectionSettings)`  
  It may take time until printing is possible.  
  Using the StarPrinterFactory class can perform part of the initialization process in advance.
  
- `async open(options: OpenOptions = new OpenOptions()): Promise<void>`  
  
- `async close(): Promise<void>`  
  
- `async print(options: PrintOptions = new PrintOptions()): Promise<void>`  
  
- `async printRawData(data: Uint8Array, options: PrintOptions = new PrintOptions()): Promise<void>`  
  
- `async getStatus(options: GetStatusOptions = new GetStatusOptions(),): Promise<StarPrinterStatus>`  
  
- `async getInformation(options: GetInformationOptions = new GetInformationOptions()): Promise<StarPrinterInformation>`  

### StarPrinterFactory class

#### Methods
- `constructor()`

- `createStarPrinter(connectionSettings: StarConnectionSettings): StarPrinter`  
  Using the constructor of the StarPrinter class may take time until printing is possible.  
  This method can shorten the time until printing is possible.
  
### Options.OpenOptions class  
  
#### Properties  
  
- `timeout: number = 10_000`  
  Timeout for connection  
  
### Options.PrintOptions class  
  
#### Properties  
  
- `timeout: number = 30_000`  
  Timeout for printing  
  
- `template: string? = null`  
  Stores template when performing template printing  
  
- `enableCheckStatus: boolean = true`  
  If false, commands are sent even when the printer is in an error state (e.g., out of paper)  
  
### Options.GetStatusOptions class  
  
#### Properties  
  
- `timeout: number = 5_000`  
  Timeout for retrieving PrinterStatus  
  
### Options.GetInformationOptions class  
  
#### Properties  
  
- `timeout: number = 5_000`  
  Timeout for retrieving PrinterInformation  
  
### StarConnectionSettings class  
  
#### Properties  
  
- `interfaceType: InterfaceType = InterfaceType.Unknown`  
  
- `identifier: string = StarConnectionSettings.FIRST_FOUND_DEVICE;`  
  Product serial number or USB serial number can be used.  
  
- `StarConnectionSettings.FIRST_FOUND_DEVICE: string`  
  Constant to assign to identifier when using the first found device  
  
### StarPrinterInformation class  
  
#### Properties  
  
- `model: StarPrinterModel`  
- `emulation: StarPrinterEmulation`  
- `detail: StarPrinterInformationDetail`  
  
### StarPrinterStatus class  
  
#### Properties  
  
- `hasError: boolean`  
- `coverOpen: boolean`  
- `drawerOpenCloseSignal: boolean`  
- `paperEmpty: boolean`  
- `paperNearEmpty: boolean`  
- `detail: StarPrinterStatusDetail`  

### StarIO10Logger class  
  
Output logs to the console  
  
#### Methods  
  
- `start()`  
  Start logging  
  
- `stop()`  
  Stop logging  
  
## Copyright  
  
Copyright 2025 Star Micronics Co., Ltd. All rights reserved.